/**
* Script: dropdown.js
* Written by: Radnen
* Updated: 1/6/2011
**/

function DropDown(parent, x, y, w)
{
	var fh = System.textFont.getHeight()+2;
	this.inherit = Control;
	this.inherit(parent, x, y, w, fh);
	
	var sel = -1;
	this.lockWidth = false;
	this.drawDrop = false;
	this.index = -1;
	this.onSelect = function(){};
	
	// array of strings:
	this.items = [];
	
	this.update = function() {
		this.updateMouse();
		if (Cursor.onLeftClick()) {
			if (!this.drawDrop) {
				if (Cursor.isWithin(this.x, this.y, this.w, this.h)) {
					this.drawDrop = !this.drawDrop;
				}
			}
			else {
				if (Cursor.isWithin(this.x, this.y+sel*fh+fh, this.w, fh)) {				
					this.index = sel;
					this.onSelect();
					this.drawDrop = false;
				}
			}
		}
	}
	
	this.draw = function() {
		this.x = this.parent.x + this.xx;
		this.y = this.parent.y + this.yy;
		if (this.lockWidth) this.w = this.parent.w - this.ww;
		
		if (this.drawDrop) {
			Rectangle(this.x, this.y, this.w, this.items.length*fh+fh, Colors.black);
			OutlinedRectangle(this.x, this.y, this.w, this.items.length*fh+fh, Colors.gray);
			var i = this.items.length;
			while(i--) {
				var y = this.y+i*fh+fh;
				if (sel == i) Rectangle(this.x, y, this.w, fh, Colors.lightBlue);
				System.textFont.drawText(this.x+4, y, this.items[i]);
				if (Cursor.isWithin(this.x, y, this.w, fh)) sel = i;
			}
		}
		Rectangle(this.x, this.y, this.w, fh, Colors.black);
		OutlinedRectangle(this.x, this.y, this.w, fh, Colors.gray);
		OutlinedRectangle(this.x+this.w-16, this.y, 16, fh, Colors.gray);
		if (this.index >= 0) System.drawText(this.x+4, this.y+2, this.items[this.index]);
		if (Cursor.isWithin(this.x, this.y, this.w, this.h)) {
			Resources.images.dn_arrow.blitMask(this.x+this.w-16, this.y, Colors.green);
		}
		else Resources.images.dn_arrow.blit(this.x+this.w-16, this.y);
	}
}